--require("assets/ui_scripts/common/style.lua");
require( "scripts/style.lua" );

--username = "ko"

GameTypeButtonGraphics = {
	"buttons/highscores_btn_purp_idle.png",
	"buttons/highscores_btn_purp_down.png",
	"buttons/highscores_btn_purp_hl.png"
};

MainButtonGraphics = {
	"buttons/btn_idle_long.png",
	"buttons/btn_down_long.png",
	"buttons/btn_hl_long.png"
};

MainFont = {
  standardFont,
  24,
  DarkPurpleColor
};

PurpleButtonFont = {
  standardFont,
  24,
  BlackColor
};

BottomFont = {
  standardFont,
  24,
  BlackColor
};

WelcomeFont = {
  standardFont,
  20,
  BlackColor
};

InviteFont = {
  standardFont,
  40,
  DarkPurpleColor
};


MakeDialog
{
	MainMenu
	{
		w=800;
		h=600;

		label = "weddingLabel",
		Bitmap
		{ 
			name="backgroundimage",
			image=UIBitmaps.Backgrounds.Menus["main"],

			Text
			{
				font = InviteFont,
				name = "welcome",
				x=112,y=160,w=180,h=40,
				mFlags = kHAlignCenter + kVAlignCenter,
				label = "invited"
			},
			
			-- Copyright info
			Text
		   {
		      font = {standardFont, 15, BlackColor},
		      name = "mm_copyright",
		      x=495,y=580,w=300,h=20,
		      flags = kHAlignRight + kVAlignCenter,
		      label = "copyright"
		   };

			-- arcade mode
			Button
			{
				x=125, y=295,
				font = PurpleButtonFont,
				graphics = GameTypeButtonGraphics,
				name="Arcade",
				label="game.mode.arcade.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/main_roll_2.ogg",
				sound = "assets/audio/sfx/main_click.ogg",
				command=
					function()
						SetCurrentGameMode(1);
						if (GetNumUsers() == 0) then
							gEnterNameValue = "";
							name = DoModal("scripts/entername.lua");
							if (not(name == nil)) then
								CreateNewUser(name);
								HideMainMenu();
								DoModal("scripts/arcadeMetamap.lua");
							end
						else
							HideMainMenu();
							DoModal("scripts/arcadeMetamap.lua");
						end
					end
				
			},
			-- career mode
			Button
			{
				x=125, y=224,
				font = PurpleButtonFont,
				graphics = GameTypeButtonGraphics,
				name="Career",
				label="game.mode.career.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/main_roll_1.ogg",
				sound = "assets/audio/sfx/main_click.ogg",
				command=
					function()
						SetCurrentGameMode(0);
						if (GetNumUsers() == 0) then
							gEnterNameValue = "";
							name = DoModal("scripts/entername.lua");
							if (not(name == nil)) then
								CreateNewUser(name);
								if(IsFirstTime() == 1) then
									HideMainMenu();
									SetComicOff();
									DoModal("scripts/comic1.lua");
								else
									HideMainMenu();
									DoModal("scripts/album.lua");
								end
							end
						else
							if(IsFirstTime() == 1) then
								SetComicOff();
								HideMainMenu();
								DoModal("scripts/comic1.lua");
							else
								HideMainMenu();
								DoModal("scripts/album.lua");
							end
						end
					end
			},
			
			Button
			{
				x=70, y = 375,
				font = MainFont,
				graphics = MainButtonGraphics,
				name="options",
				label="ui.dialog.options.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/main_roll_3.ogg",
				sound = "assets/audio/sfx/main_click.ogg",
				command=
					function()
						DoModal("scripts/options.lua");
					end
			},
			
			Button
			{
				x=202, y=375,
				font = MainFont,
				graphics = MainButtonGraphics,
				name="highscores",
				label="ui.dialog.highscore.title",
				type = kPush,
				rolloversound = "assets/audio/sfx/main_roll_4.ogg",
				sound = "assets/audio/sfx/main_click.ogg",
				command=
					function()
						DoModal("scripts/hiscore.lua");
					end
			},
			
			Button
			{
				x=70, y = 422,
				font = MainFont,
				graphics = MainButtonGraphics,
				name="help",
				label="ui.dialog.help.title",
				type = kPush,
				rolloversound = "assets/audio/sfx/main_roll_5.ogg",
				sound = "assets/audio/sfx/main_click.ogg",
				command=
					function()
						DoModal("scripts/helpmenu1.lua");
					end
			},
			
			Button
			{
				x=202, y = 422,
				font = MainFont,
				graphics = MainButtonGraphics,
				name="quit",
				label="common.quit.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/main_roll_6.ogg",
				sound = "assets/audio/sfx/main_click.ogg",
				command=
					function() 
						result = 
						DisplayDialog
						{ 
							"scripts/yesno.lua",
							body ="ui.dialog.quit.confirm",
							title = "ui.dialog.quit.title" 
						};
						if (result=='yes') then
							PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) );
						end
					end
			},
			
			Text
			{
				font = WelcomeFont,
				name = "welcome",
				x=505,y=515,w=kMax,h=30,
				mFlags = kHAlignCenter + kVAlignCenter,
				label = "welcome"
			},
			
			Button
			{
				x=500,				
				y=535,
				font = BottomFont,
				graphics = MainButtonGraphics,
				name="changeplayer",
				label="ui.dialog.highscores.global.enter_name.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/main_roll.ogg",
				sound = "assets/audio/sfx/main_click.ogg",
				command=
					function()
					    --SetWelcomeName();
						--DoModal("ui_scripts/dialogs/choose_player_dlg.lua");
						DoModal("scripts/chooseplayer.lua");
					end
			},

			Button
			{
				x=640, 
				y=535,
				font = BottomFont,
				graphics = MainButtonGraphics,
				name="moregames",
				label="ui.dialog.highscores.global.more_games.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/main_roll.ogg",
				sound = "assets/audio/sfx/main_click.ogg",
				command=
					function()
						DoModal("xsell/xsell.lua");
					end
			},
		},	  
	}
}
